from matplotlib import pyplot as plt
import numpy as np
import pandas as pd

plt.style.use("fivethirtyeight")

# lets say we have a project that we are allowed to work for a max 8 hours a day
# and want to track who is working on the project and for how long
days = [1,2,3,4,5,6,7,8,9]

player1 = [8,6,5,5,4,2,1,1,0] # original developer
player2 = [0,1,2,2,2,4,4,4,4] # 1st new developer slowly taking over
player3 = [0,1,1,1,2,2,3,3,4] # 2nd new developer slowly taking over

labels = ["Worker 1", "Worker 2", "Workers 3"]
colors = ["#008fd5", "#fd4f30", "#6d904f"]


plt.figure(2)
plt.stackplot(days, player1, player2, player3, labels=labels,
                colors=colors)
#plt.legend(loc="lower left")
plt.legend(loc=(0.07, 0.05)) # assign coordinates of the bottom left corner, 
# 7% from bottom, 5% from left
plt.title("My awesome stack plot")
plt.tight_layout()

plt.show()